/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Adc_Filter.c
\brief      This file performs the filtering of all ADC samples.
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       11/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#include "Adc_Filter.h"

 /*------------- Global Variables  ---------------------------------------------------*/
uint16_t u16AdcCollectResults[50];


/****************************************************************************************/
/**
 * \brief     Start ADC Averaging on every configured channels.
 * \author    R01160
 * \param     none
 * \return    none
 */  
void vfnADC_Start_Average(void)
{
	
}

/****************************************************************************************/
/**
 * \brief     Stops ADC averaging on the whole driver.
 * \author    R01160
 * \param     none
 * \return    none
 */  
void vfnADC_Stop_Average(void)
{
	
}

void vfnAdc_Collect_Results(void)
{
  /* static uint8_t u8SampleCntr = 0;
    
   ADC_CONVERT_AND_READ(ADC_CHANNEL_0,u16AdcCollectResults[u8SampleCntr]);    
   u8SampleCntr++;	*/
   
   ADC_CONVERT_AND_READ_EDMA_FLG(ADC_CHANNEL_0);
}

/*******************************************************************************************/
/* Parameter declaration */
#ifdef ATDFLTR_0_AVERAGE
//Initialise channelstruct for ATD0
tAdcFltr_ChannelStruct AdcFltr_0_ChannelStruct[ATDFLTR_0_AVERAGECHANNELS];


tAdcFltr_FilterStruct sATD0 = 
{
  &AdcFltr_0_ChannelStruct[0], 
  {
    ATDFLTR_0_AVERAGETAPS, ATDFLTR_0_AVERAGECHANNELS, ATDFLTR_0_AVERAGEINTERRUPT
  }
};                    
/* Filter struct */
uint16_t xl_atd0_channel[ATDFLTR_0_AVERAGECHANNELS][ATDFLTR_0_AVERAGETAPS + 1];	   /* Circular buffer      */
uint16_t xl_atd0_FilterResults[ATDFLTR_0_AVERAGECHANNELS];                         /* array of all results */

#ifndef ATDFLTR_0_AVERAGE0
#define ATDFLTR_0_AVERAGE0 0
#endif
#ifndef ATDFLTR_0_AVERAGE1
#define ATDFLTR_0_AVERAGE1 0
#endif
#ifndef ATDFLTR_0_AVERAGE2
#define ATDFLTR_0_AVERAGE2 0
#endif
#ifndef ATDFLTR_0_AVERAGE2
#define ATDFLTR_0_AVERAGE2 0
#endif
#ifndef ATDFLTR_0_AVERAGE4
#define ATDFLTR_0_AVERAGE4 0
#endif
#ifndef ATDFLTR_0_AVERAGE5
#define ATDFLTR_0_AVERAGE5 0
#endif
#ifndef ATDFLTR_0_AVERAGE6
#define ATDFLTR_0_AVERAGE6 0
#endif
#ifndef ATDFLTR_0_AVERAGE7
#define ATDFLTR_0_AVERAGE7 0
#endif
#ifndef ATDFLTR_0_AVERAGE8
#define ATDFLTR_0_AVERAGE8 0
#endif
#ifndef ATDFLTR_0_AVERAGE9
#define ATDFLTR_0_AVERAGE9 0
#endif
#ifndef ATDFLTR_0_AVERAGE10
#define ATDFLTR_0_AVERAGE10 0
#endif
#ifndef ATDFLTR_0_AVERAGE11
#define ATDFLTR_0_AVERAGE11 0
#endif
#ifndef ATDFLTR_0_AVERAGE12
#define ATDFLTR_0_AVERAGE12 0
#endif
#ifndef ATDFLTR_0_AVERAGE13
#define ATDFLTR_0_AVERAGE13 0
#endif
#ifndef ATDFLTR_0_AVERAGE14
#define ATDFLTR_0_AVERAGE14 0
#endif
#ifndef ATDFLTR_0_AVERAGE15
#define ATDFLTR_0_AVERAGE15 0
#endif

#endif

#ifdef ADCFLTR_1_AVERAGE
//Initialise channelstruct for ATD1
tAdcFltr_ChannelStruct AdcFltr_1_ChannelStruct[ADCFLTR_1_AVERAGECHANNELS];

tAdcFltr_FilterStruct sATD1 = 
{
  &AdcFltr_1_ChannelStruct[0],
  {
    ADCFLTR_1_AVERAGETAPS, ADCFLTR_1_AVERAGECHANNELS, ADCFLTR_1_AVERAGEINTERRUPT
  }
};                    /* Control struct */

/* Filter struct */
uint16_t xl_atd1_channel[ADCFLTR_1_AVERAGECHANNELS][ADCFLTR_1_AVERAGETAPS + 1];	   /* Circular buffer      */
uint16_t xl_atd1_FilterResults[ADCFLTR_1_AVERAGECHANNELS];                         /* array of all results */

#ifndef ADCFLTR_1_AVERAGE0
#define ADCFLTR_1_AVERAGE0 0
#endif
#ifndef ADCFLTR_1_AVERAGE1
#define ADCFLTR_1_AVERAGE1 0
#endif
#ifndef ADCFLTR_1_AVERAGE2
#define ADCFLTR_1_AVERAGE2 0
#endif
#ifndef ADCFLTR_1_AVERAGE2
#define ADCFLTR_1_AVERAGE2 0
#endif
#ifndef ADCFLTR_1_AVERAGE4
#define ADCFLTR_1_AVERAGE4 0
#endif
#ifndef ADCFLTR_1_AVERAGE5
#define ADCFLTR_1_AVERAGE5 0
#endif
#ifndef ADCFLTR_1_AVERAGE6
#define ADCFLTR_1_AVERAGE6 0
#endif
#ifndef ADCFLTR_1_AVERAGE7
#define ADCFLTR_1_AVERAGE7 0
#endif
#ifndef ADCFLTR_1_AVERAGE8
#define ADCFLTR_1_AVERAGE8 0
#endif
#ifndef ADCFLTR_1_AVERAGE9
#define ADCFLTR_1_AVERAGE9 0
#endif
#ifndef ADCFLTR_1_AVERAGE10
#define ADCFLTR_1_AVERAGE10 0
#endif
#ifndef ADCFLTR_1_AVERAGE11
#define ADCFLTR_1_AVERAGE11 0
#endif
#ifndef ADCFLTR_1_AVERAGE12
#define ADCFLTR_1_AVERAGE12 0
#endif
#ifndef ADCFLTR_1_AVERAGE13
#define ADCFLTR_1_AVERAGE13 0
#endif
#ifndef ADCFLTR_1_AVERAGE14
#define ADCFLTR_1_AVERAGE14 0
#endif
#ifndef ADCFLTR_1_AVERAGE15
#define ADCFLTR_1_AVERAGE15 0
#endif


#endif



/*******************************************************************************************/
void xl_atd_Average(tAdcFltr_FilterStruct* filter)
{
  uint16_t  i;
  uint16_t  u16TAPSIx;
  uint16_t  u16bufferIndex;
  uint16_t  u16numTAPS;
  vuint16_t vu16result;
  uint16_t* pu16sampleBuffer;
  tAdcFltr_ChannelStruct* ptrchannel;
  
  u16numTAPS = filter->config.numTAPS;    //numTAPS is very commonly used
  /* For each channel: collect the new conversion, add to channel buffer, compute new filter value */
  for (i=0;i<filter->config.numChannels;i++)
  {
    ptrchannel = filter->channels;
    /* Get position in buffer */
    pu16sampleBuffer = ptrchannel[i].pSampleBuffer;
	u16bufferIndex = pu16sampleBuffer[u16numTAPS];
		
    /* Move value in ATD result register to buffer - values saved in reverse order */
    pu16sampleBuffer[u16bufferIndex] = *ptrchannel[i].pResultRegister;

    /* Compute filter  */
    vu16result = 0;
    
    for (u16TAPSIx=0;u16TAPSIx<u16numTAPS;u16TAPSIx++)
    {
      vu16result = (vuint16_t)((vuint16_t)pu16sampleBuffer[u16bufferIndex] + (vuint16_t)vu16result);
      u16bufferIndex++; /* go back in discrete time */
      if (u16bufferIndex == u16numTAPS) 
      {
        u16bufferIndex = 0;	
      }
    }
    if (u16bufferIndex == 0) 
    {
      u16bufferIndex = ((uint16_t)(uint16_t)u16numTAPS - (uint16_t)1);	
    }
    else 
    {
       u16bufferIndex--; /* next entry in buffer */
    }
    pu16sampleBuffer[u16numTAPS] = u16bufferIndex;
    
    /* Normalise using integer arithmetic */
#if ATDFLTR_0_AVERAGETAPS == ADCFLTR_1_AVERAGETAPS
    vu16result = (vuint16_t)((vuint16_t)vu16result/(vuint16_t)ATDFLTR_0_AVERAGETAPS);
#else
    vu16result = (vuint16_t)((vuint16_t)vu16result/(vuint16_t)u16numTAPS);
#endif
    /* Update result - no semaphore, CPU must use external synchronisation */
    *ptrchannel[i].pFilterResult = vu16result;
  }
 // if (filter->config.interruptCPU) _sif();
}

/*******************************************************************************************/
//Initialisation routine
void xl_atd_initaverage(void)
{
  uint8_t u8FltrIx;
  uint8_t u8FltrNum;
  
#ifdef ATDFLTR_0_AVERAGE
  /*Initialise each filter channel */
  for (u8FltrIx=0; u8FltrIx<ATDFLTR_0_AVERAGECHANNELS;u8FltrIx++)
  {
    AdcFltr_0_ChannelStruct[u8FltrIx].pSampleBuffer = &xl_atd0_channel[u8FltrIx][0];
    if (u8FltrIx==0)  u8FltrNum=ATDFLTR_0_AVERAGE0;
    if (u8FltrIx==1)  u8FltrNum=ATDFLTR_0_AVERAGE1;
    if (u8FltrIx==2)  u8FltrNum=ATDFLTR_0_AVERAGE2;
    if (u8FltrIx==3)  u8FltrNum=ATDFLTR_0_AVERAGE3;
    if (u8FltrIx==4)  u8FltrNum=ATDFLTR_0_AVERAGE4;
    if (u8FltrIx==5)  u8FltrNum=ATDFLTR_0_AVERAGE5;
    if (u8FltrIx==6)  u8FltrNum=ATDFLTR_0_AVERAGE6;
    if (u8FltrIx==7)  u8FltrNum=ATDFLTR_0_AVERAGE7;
   /* if (i==8)  j=ATDFLTR_0_AVERAGE8;
    if (i==9)  j=ATDFLTR_0_AVERAGE9;
    if (i==10) j=ATDFLTR_0_AVERAGE10;
    if (i==11) j=ATDFLTR_0_AVERAGE11;
    if (i==12) j=ATDFLTR_0_AVERAGE12;
    if (i==13) j=ATDFLTR_0_AVERAGE13;
    if (i==14) j=ATDFLTR_0_AVERAGE14;
    if (i==15) j=ATDFLTR_0_AVERAGE15;
    */
    AdcFltr_0_ChannelStruct[u8FltrIx].pResultRegister = &rQUEUE0;  ;//&ATD0.atddr[j];
    AdcFltr_0_ChannelStruct[u8FltrIx].pFilterResult = &xl_atd0_FilterResults[u8FltrIx];
  }
#endif
#ifdef ADCFLTR_1_AVERAGE
  /*Initialise each filter channel */
  for (u8FltrIx=0; u8FltrIx<ADCFLTR_1_AVERAGECHANNELS;u8FltrIx++)
  {
    AdcFltr_1_ChannelStruct[u8FltrIx].pSampleBuffer = &xl_atd1_channel[u8FltrIx][0];
    if (u8FltrIx==0)  u8FltrNum=ADCFLTR_1_AVERAGE0;
    if (u8FltrIx==1)  u8FltrNum=ADCFLTR_1_AVERAGE1;
    if (u8FltrIx==2)  u8FltrNum=ADCFLTR_1_AVERAGE2;
    if (u8FltrIx==3)  u8FltrNum=ADCFLTR_1_AVERAGE3;
    if (u8FltrIx==4)  u8FltrNum=ADCFLTR_1_AVERAGE4;
    if (u8FltrIx==5)  u8FltrNum=ADCFLTR_1_AVERAGE5;
    if (u8FltrIx==6)  u8FltrNum=ADCFLTR_1_AVERAGE6;
    if (u8FltrIx==7)  u8FltrNum=ADCFLTR_1_AVERAGE7;
    if (u8FltrIx==8)  u8FltrNum=ADCFLTR_1_AVERAGE8;
    if (u8FltrIx==9)  u8FltrNum=ADCFLTR_1_AVERAGE9;
    /*if (i==10) j=ADCFLTR_1_AVERAGE10;
    if (i==11) j=ADCFLTR_1_AVERAGE11;
    if (i==12) j=ADCFLTR_1_AVERAGE12;
    if (i==13) j=ADCFLTR_1_AVERAGE13;
    if (i==14) j=ADCFLTR_1_AVERAGE14;
    if (i==15) j=ADCFLTR_1_AVERAGE15;*/
    AdcFltr_1_ChannelStruct[u8FltrIx].pResultRegister = &rQUEUE0; //ATD1.atddr[j];
    AdcFltr_1_ChannelStruct[u8FltrIx].pFilterResult = &xl_atd1_FilterResults[u8FltrIx];
  }
#endif

  /* Clear interrupt flag */
  //XGATE.xgswt.word = 0x01fe;
}